//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Outlaws
//  Copyright (C) 2016 RETROBYTES PRODUCTIONS
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------


#include "video.h"

u8 level;
u8* const g_scrbuffers[2] = {SCR_VMEM, SCR_BUFF};

// Create a 256-byte aligned transparent mask table, for mode 0,
// using palette colour index 15 as transparent
cpctm_createTransparentMaskTable(g_transparencyMaskTable, 0x1600, M0, 0);

void drawClippedSpriteOnBuffer(u8* sprite, i8 xPos, u8 yPos, u8 width, u8 height, u8* buffer){

    u8 h = height - 1;

    //In this case we don't have to clip
    if(xPos >= MIN_X && xPos + width <= MAX_X){

        cpct_drawSpriteMaskedAlignedTable(sprite, cpct_getScreenPtr(buffer, xPos, yPos), width, height, g_transparencyMaskTable);

    }
    else if(xPos <= MAX_X && xPos + width > MAX_X){ //Right clip

        while(height){

            cpct_drawSpriteMaskedAlignedTable(sprite + (h * width), cpct_getScreenPtr(buffer, xPos, yPos + h), MAX_X - xPos + 1, 1, g_transparencyMaskTable);

            height--;
            h--;
        }

    }
    else if(xPos < MIN_X && xPos + width > MIN_X){ //Left clip

        while(height) {

            cpct_drawSpriteMaskedAlignedTable(sprite + (MIN_X - xPos) + (h * width), cpct_getScreenPtr(buffer, MIN_X, yPos + h), width - (MIN_X - xPos), 1, g_transparencyMaskTable);

            height--;
            h--;
        }

    }

}

void drawClippedSprite(u8* sprite, i8 xPos, u8 yPos, u8 width, u8 height){

	drawClippedSpriteOnBuffer(sprite,xPos, yPos,width, height, g_scrbuffers[1]);

}

void drawTileBox2x4(i8 txPos, u8 tyPos, u8 tWidth, u8 tHeight, u8* buffer, u8 map){

	int x, y;

	u8* tilemap = G_levelTilemaps + map * 20 * 16;
	u8* pvideo;

	for(y=tyPos;y < tyPos + tHeight && y < 16;y++){

		for(x=txPos;x < txPos + tWidth && x < 20;x++){

			pvideo = cpct_getScreenPtr(buffer, 4 * x, 8 * y);
			cpct_drawTileAligned4x8_f (G_tiles + (*(tilemap + x + y * 20) * 32), pvideo);

		}

	}


}

void eraseClippedSprite(i8 xPos, u8 yPos, u8 width, u8 height){

	u8 tWidth = width / 4, tHeight = height / 8;

	if(xPos < 0){

		width += xPos;
		xPos = 0;

	}

	tWidth  += ((xPos + width)  % 4 ? 1 : 0);
	tHeight += ((yPos + height) % 8 ? 1 : 0);

	drawTileBox2x4(xPos / 4, yPos / 8, tWidth + 1, tHeight + 1, g_scrbuffers[1], level - 1);

}

void forceFrontBuffer(u8** scrbuffers){

	scrbuffers[0] = SCR_BUFF;
	scrbuffers[1] = SCR_VMEM;

	cpct_setVideoMemoryPage( (u16)(scrbuffers[1]) >> 10 );

}

void swapBuffers(u8** scrbuffers) {
    
    u8* aux; // Auxiliary pointer for making the change
    
    cpct_setVideoMemoryPage( (u16)(scrbuffers[1]) >> 10 );
    
    aux = scrbuffers[0];
    scrbuffers[0] = scrbuffers[1];
    scrbuffers[1] = aux;
}
